/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.function.Consumer;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyStatementTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S2711")
public class ReturnYieldOutsideFunctionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this use of \"%s\".";
    public static final String CHECK_KEY = "S2711";
    private static final Consumer<SubscriptionContext> SUBSCRIPTION_CONTEXT_CONSUMER = ctx -> {
        PyStatementTree returnStatement = (PyStatementTree)ctx.syntaxNode();
        for (Tree currentParent = returnStatement.parent(); currentParent != null; currentParent = currentParent.parent()) {
            if (currentParent.is(Tree.Kind.FUNCDEF)) {
                return;
            }
            if (!currentParent.is(Tree.Kind.CLASSDEF)) continue;
            ctx.addIssue((Tree)returnStatement, String.format(MESSAGE, returnStatement.firstToken().getValue()));
            return;
        }
        ctx.addIssue((Tree)returnStatement, String.format(MESSAGE, returnStatement.firstToken().getValue()));
    };

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.YIELD_STMT, SUBSCRIPTION_CONTEXT_CONSUMER);
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_STMT, SUBSCRIPTION_CONTEXT_CONSUMER);
    }
}

