/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.Token;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonBuiltinFunctions;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyAliasedNameTree;
import org.sonar.python.api.tree.PyAnnotatedAssignmentTree;
import org.sonar.python.api.tree.PyAssignmentStatementTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionListTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyImportFromTree;
import org.sonar.python.api.tree.PyImportNameTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyStatementTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S1656")
public class SelfAssignmentCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1656";
    public static final String MESSAGE = "Remove or correct this useless self-assignment.";
    private Set<String> importedNames = new HashSet<String>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> this.importedNames.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_FROM, ctx -> ((PyImportFromTree)ctx.syntaxNode()).importedNames().forEach(this::addImportedName));
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, ctx -> ((PyImportNameTree)ctx.syntaxNode()).modules().forEach(this::addImportedName));
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::checkAssignement);
        context.registerSyntaxNodeConsumer(Tree.Kind.ANNOTATED_ASSIGNMENT, this::checkAnnotatedAssignment);
    }

    private void checkAssignement(SubscriptionContext ctx) {
        PyAssignmentStatementTree assignment = (PyAssignmentStatementTree)ctx.syntaxNode();
        PyExpressionTree assignedValue = assignment.assignedValue();
        for (int i = 0; i < assignment.lhsExpressions().size(); ++i) {
            List expressions = ((PyExpressionListTree)assignment.lhsExpressions().get(i)).expressions();
            if (expressions.size() != 1 || !CheckUtils.areEquivalent((Tree)assignedValue, (Tree)expressions.get(0)) || this.isException((PyStatementTree)assignment, assignedValue)) continue;
            ctx.addIssue((Token)assignment.equalTokens().get(i), MESSAGE);
        }
    }

    private void checkAnnotatedAssignment(SubscriptionContext ctx) {
        PyExpressionTree variable;
        PyAnnotatedAssignmentTree assignment = (PyAnnotatedAssignmentTree)ctx.syntaxNode();
        PyExpressionTree assignedValue = assignment.assignedValue();
        if (CheckUtils.areEquivalent((Tree)assignedValue, (Tree)(variable = assignment.variable())) && !this.isException((PyStatementTree)assignment, assignedValue)) {
            ctx.addIssue(assignment.equalToken(), MESSAGE);
        }
    }

    private void addImportedName(PyAliasedNameTree aliasedName) {
        if (aliasedName.alias() != null) {
            this.importedNames.add(aliasedName.alias().name());
        } else {
            List names = aliasedName.dottedName().names();
            this.importedNames.add(((PyNameTree)names.get(names.size() - 1)).name());
        }
    }

    private boolean isException(PyStatementTree assignment, PyExpressionTree assignedValue) {
        if (assignedValue.is(Tree.Kind.NAME) && this.isAllowedName((PyNameTree)assignedValue)) {
            return true;
        }
        return SelfAssignmentCheck.inClassDef((Tree)assignment) || SelfAssignmentCheck.hasCallExpressionDescendant((Tree)assignment);
    }

    private boolean isAllowedName(PyNameTree name) {
        return this.importedNames.contains(name.name()) || PythonBuiltinFunctions.contains(name.name());
    }

    private static boolean inClassDef(Tree tree) {
        Tree currentParent = tree.parent();
        currentParent = currentParent.is(Tree.Kind.STATEMENT_LIST) ? currentParent.parent() : currentParent;
        return currentParent.is(Tree.Kind.CLASSDEF);
    }

    private static boolean hasCallExpressionDescendant(Tree tree) {
        CallExpressionDescendantVisitor visitor = new CallExpressionDescendantVisitor();
        tree.accept((PyTreeVisitor)visitor);
        return visitor.hasCallExpressionDescendant;
    }

    private static class CallExpressionDescendantVisitor
    extends BaseTreeVisitor {
        private boolean hasCallExpressionDescendant = false;

        private CallExpressionDescendantVisitor() {
        }

        public void visitCallExpression(PyCallExpressionTree callExpressionTree) {
            this.hasCallExpressionDescendant = true;
        }
    }
}

