/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyLambdaExpressionTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S107")
public class TooManyParametersCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S107";
    private static final String MESSAGE = "%s has %s parameters, which is greater than the %s authorized.";
    private static final int DEFAULT_MAX = 7;
    @RuleProperty(key="max", defaultValue="7")
    public int max = 7;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            int nbParameters;
            PyFunctionDefTree tree = (PyFunctionDefTree)ctx.syntaxNode();
            if (tree.parameters() != null && (nbParameters = tree.parameters().all().size()) > this.max) {
                String typeName = tree.isMethodDefinition() ? "Method" : "Function";
                String name = String.format("%s \"%s\"", typeName, tree.name().name());
                String message = String.format(MESSAGE, name, nbParameters, this.max);
                ctx.addIssue((Tree)tree.parameters(), message);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.LAMBDA, ctx -> {
            int nbParameters;
            PyLambdaExpressionTree tree = (PyLambdaExpressionTree)ctx.syntaxNode();
            if (tree.parameters() != null && (nbParameters = tree.parameters().all().size()) > this.max) {
                String name = "Lambda";
                String message = String.format(MESSAGE, name, nbParameters, this.max);
                ctx.addIssue((Tree)tree.parameters(), message);
            }
        });
    }
}

