/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyReturnStatementTree;
import org.sonar.python.api.tree.PyStatementTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyYieldStatementTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S1142")
public class TooManyReturnsCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1142";
    private static final int DEFAULT_MAX = 3;
    private static final String MESSAGE = "This function has %s returns or yields, which is more than the %s allowed.";
    @RuleProperty(key="max", defaultValue="3")
    public int max = 3;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            PyFunctionDefTree func = (PyFunctionDefTree)ctx.syntaxNode();
            ReturnCountVisitor returnCountVisitor = new ReturnCountVisitor();
            func.body().accept((PyTreeVisitor)returnCountVisitor);
            if (returnCountVisitor.returnStatements.size() > this.max) {
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)func.name(), String.format(MESSAGE, returnCountVisitor.returnStatements.size(), this.max));
                returnCountVisitor.returnStatements.forEach(r -> preciseIssue.secondary((Tree)r, null));
            }
        });
    }

    private static class ReturnCountVisitor
    extends BaseTreeVisitor {
        private List<PyStatementTree> returnStatements = new ArrayList<PyStatementTree>();

        private ReturnCountVisitor() {
        }

        public void visitFunctionDef(PyFunctionDefTree pyFunctionDefTree) {
        }

        public void visitReturnStatement(PyReturnStatementTree pyReturnStatementTree) {
            super.visitReturnStatement(pyReturnStatementTree);
            this.returnStatements.add((PyStatementTree)pyReturnStatementTree);
        }

        public void visitYieldStatement(PyYieldStatementTree pyYieldStatementTree) {
            super.visitYieldStatement(pyYieldStatementTree);
            this.returnStatements.add((PyStatementTree)pyYieldStatementTree);
        }
    }
}

