/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyParenthesizedExpressionTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S1110")
public class UselessParenthesisCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1110";
    private static final String MESSAGE = "Remove those useless parentheses.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.PARENTHESIZED, ctx -> {
            PyParenthesizedExpressionTree parenthesized = (PyParenthesizedExpressionTree)ctx.syntaxNode();
            PyExpressionTree expression = parenthesized.expression();
            if (expression.is(Tree.Kind.PARENTHESIZED) || expression.is(Tree.Kind.TUPLE) || expression.is(Tree.Kind.GENERATOR_EXPR)) {
                ctx.addIssue(parenthesized.leftParenthesis(), MESSAGE).secondary(parenthesized.rightParenthesis(), null);
            }
        });
    }
}

