/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonCheckAstNode;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4784")
public class RegexCheck
extends PythonCheckAstNode {
    public static final String CHECK_KEY = "S4784";
    private static final String MESSAGE = "Make sure that using a regular expression is safe here.";
    private static final int REGEX_ARGUMENT = 0;
    private static final Set<String> questionableFunctions = RegexCheck.immutableSet((Object[])new String[]{"django.core.validators.RegexValidator", "django.urls.re_path", "re.compile", "re.match", "re.search", "re.fullmatch", "re.split", "re.findall", "re.finditer", "re.sub", "re.subn", "regex.compile", "regex.match", "regex.search", "regex.fullmatch", "regex.split", "regex.findall", "regex.finditer", "regex.sub", "regex.subn", "regex.subf", "regex.subfn", "regex.splititer"});

    public Set<AstNodeType> subscribedKinds() {
        return RegexCheck.immutableSet((Object[])new AstNodeType[]{PythonGrammar.ATTRIBUTE_REF, PythonGrammar.ATOM});
    }

    public void visitNode(AstNode node) {
        AstNode argListNode;
        AstNode parent;
        Symbol symbol = this.getContext().symbolTable().getSymbol(node);
        if (symbol != null && questionableFunctions.contains(symbol.qualifiedName()) && (parent = node.getParent()) != null && parent.is(new AstNodeType[]{PythonGrammar.CALL_EXPR}) && (argListNode = parent.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST})) != null) {
            this.checkRegexArgument((AstNode)argListNode.getChildren().get(0));
        }
    }

    private void checkRegexArgument(AstNode arg) {
        AstNode expressionStatement;
        AstNode atom = arg.getFirstDescendant(new AstNodeType[]{PythonGrammar.ATOM});
        if (atom == null) {
            return;
        }
        String literal = atom.getTokenValue();
        Symbol argSymbol = this.getContext().symbolTable().getSymbol(atom);
        IssueLocation secondaryLocation = null;
        if (argSymbol != null && argSymbol.writeUsages().size() == 1 && RegexCheck.isAssignment(expressionStatement = ((AstNode)argSymbol.writeUsages().iterator().next()).getFirstAncestor((AstNodeType)PythonGrammar.EXPRESSION_STMT))) {
            AstNode expression = (AstNode)expressionStatement.getChildren().get(2);
            literal = expression.getTokenValue();
            secondaryLocation = IssueLocation.preciseLocation((AstNode)expression, (String)"");
        }
        if (RegexCheck.isSuspiciousRegex(literal)) {
            PythonCheck.PreciseIssue preciseIssue = this.addIssue(atom, MESSAGE);
            if (secondaryLocation != null) {
                preciseIssue.secondary(secondaryLocation);
            }
        }
    }

    private static boolean isAssignment(@CheckForNull AstNode expressionStatement) {
        return expressionStatement != null && expressionStatement.getChildren().size() == 3 && ((AstNode)expressionStatement.getChildren().get(1)).is(new AstNodeType[]{PythonPunctuator.ASSIGN});
    }

    private static boolean isSuspiciousRegex(String regexp) {
        if (regexp.length() > 2) {
            int nOfSuspiciousChars = regexp.length() - regexp.replaceAll("[*+{]", "").length();
            return nOfSuspiciousChars > 1;
        }
        return false;
    }
}

