/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4829")
public class StandardInputCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S4829";
    private static final String MESSAGE = "Make sure that reading the standard input is safe here.";
    private static final Set<String> questionableFunctions = StandardInputCheck.immutableSet("fileinput.input", "fileinput.FileInput");
    private static final Set<String> questionableFunctionsBuiltIn = StandardInputCheck.immutableSet("raw_input", "input", "sys.stdin.read", "sys.stdin.readline", "sys.stdin.readlines", "sys.__stdin__.read", "sys.__stdin__.readline", "sys.__stdin__.readlines");
    private static final Set<String> questionablePropertyAccess = StandardInputCheck.immutableSet("sys.stdin", "sys.__stdin__");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            PyCallExpressionTree callExpr = (PyCallExpressionTree)ctx.syntaxNode();
            if (questionableFunctionsBuiltIn.contains(StandardInputCheck.getFunctionName(callExpr.callee()))) {
                ctx.addIssue((Tree)callExpr, this.message());
            } else {
                this.visitNode((SubscriptionContext)ctx);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, ctx -> {
            PyNameTree node = (PyNameTree)ctx.syntaxNode();
            if (StandardInputCheck.isWithinImport((Tree)node)) {
                return;
            }
            if (StandardInputCheck.isQuestionablePropertyAccess(node, ctx)) {
                ctx.addIssue((Tree)node, this.message());
            }
        });
    }

    private static String getFunctionName(PyExpressionTree expr) {
        String functionName = "";
        if (expr.is(Tree.Kind.QUALIFIED_EXPR)) {
            PyQualifiedExpressionTree qualExpr = (PyQualifiedExpressionTree)expr;
            functionName = StandardInputCheck.getFunctionName(qualExpr.qualifier()) + "." + qualExpr.name().name();
        } else if (expr.is(Tree.Kind.NAME)) {
            functionName = ((PyNameTree)expr).name();
        }
        return functionName;
    }

    @Override
    protected boolean isException(PyCallExpressionTree callExpression) {
        return !callExpression.arguments().isEmpty();
    }

    private static boolean isQuestionablePropertyAccess(PyNameTree pyNameTree, SubscriptionContext ctx) {
        Symbol symbol = ctx.symbolTable().getSymbol((PyExpressionTree)pyNameTree);
        return symbol != null && questionablePropertyAccess.contains(symbol.qualifiedName());
    }

    @Override
    protected Set<String> functionsToCheck() {
        return questionableFunctions;
    }

    @Override
    protected String message() {
        return MESSAGE;
    }
}

