/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyNumericLiteralTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4426")
public class StrongCryptographicKeysCheck
extends PythonSubscriptionCheck {
    private static final Pattern CRYPTOGRAPHY = Pattern.compile("cryptography.hazmat.primitives.asymmetric.(rsa|dsa|ec).generate_private_key");
    private static final Pattern CRYPTOGRAPHY_FORBIDDEN_CURVE = Pattern.compile("(SECP192R1|SECT163K1|SECT163R2)");
    private static final Pattern CRYPTO = Pattern.compile("Crypto.PublicKey.(RSA|DSA).generate");
    private static final Pattern CRYPTODOME = Pattern.compile("Cryptodome.PublicKey.(RSA|DSA).generate");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            PyCallExpressionTree callExpression = (PyCallExpressionTree)ctx.syntaxNode();
            List arguments = callExpression.arguments();
            String qualifiedName = StrongCryptographicKeysCheck.getQualifiedName(callExpression, ctx);
            if (CRYPTOGRAPHY.matcher(qualifiedName).matches()) {
                new CryptographyModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            } else if (CRYPTO.matcher(qualifiedName).matches()) {
                new CryptoModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            } else if (CRYPTODOME.matcher(qualifiedName).matches()) {
                new CryptodomeModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            }
        });
    }

    private static String getQualifiedName(PyCallExpressionTree callExpression, SubscriptionContext ctx) {
        Symbol symbol;
        PyExpressionTree node = callExpression.callee();
        String functionNameSuffix = "";
        if (node.is(Tree.Kind.QUALIFIED_EXPR)) {
            functionNameSuffix = "." + ((PyQualifiedExpressionTree)node).name().name();
            node = ((PyQualifiedExpressionTree)node).qualifier();
        }
        return (symbol = ctx.symbolTable().getSymbol(node)) != null ? symbol.qualifiedName() + functionNameSuffix : "";
    }

    private static class CryptodomeModuleCheck
    extends CryptoAPICheck {
        private CryptodomeModuleCheck() {
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 2;
        }

        @Override
        protected String getExponentKeywordName() {
            return "e";
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "bits";
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 0;
        }
    }

    private static class CryptoModuleCheck
    extends CryptoAPICheck {
        private CryptoModuleCheck() {
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 3;
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 0;
        }

        @Override
        protected String getExponentKeywordName() {
            return "e";
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "bits";
        }
    }

    private static class CryptographyModuleCheck
    extends CryptoAPICheck {
        private CryptographyModuleCheck() {
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 1;
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 0;
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "key_size";
        }

        @Override
        protected String getExponentKeywordName() {
            return "public_exponent";
        }
    }

    private static abstract class CryptoAPICheck {
        private static final int CURVE_ARGUMENT_POSITION = 0;

        private CryptoAPICheck() {
        }

        abstract int getKeySizeArgumentPosition();

        abstract int getExponentArgumentPosition();

        abstract String getKeySizeKeywordName();

        abstract String getExponentKeywordName();

        private boolean isNonCompliantKeySizeArgument(PyArgumentTree argument, int index) {
            PyNameTree keywordArgument = argument.keywordArgument();
            if (keywordArgument == null) {
                return index == this.getKeySizeArgumentPosition() && CryptoAPICheck.isLessThan2048(argument.expression());
            }
            return keywordArgument.name().equals(this.getKeySizeKeywordName()) && CryptoAPICheck.isLessThan2048(argument.expression());
        }

        private boolean isNonCompliantExponentArgument(PyArgumentTree argument, int index) {
            PyNameTree keywordArgument = argument.keywordArgument();
            if (keywordArgument == null) {
                return index == this.getExponentArgumentPosition() && CryptoAPICheck.isLessThan65537(argument.expression());
            }
            return keywordArgument.name().equals(this.getExponentKeywordName()) && CryptoAPICheck.isLessThan65537(argument.expression());
        }

        private static boolean isLessThan2048(PyExpressionTree expression) {
            try {
                return expression.is(Tree.Kind.NUMERIC_LITERAL) && ((PyNumericLiteralTree)expression).valueAsLong() < 2048L;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        private static boolean isLessThan65537(PyExpressionTree expression) {
            try {
                return expression.is(Tree.Kind.NUMERIC_LITERAL) && ((PyNumericLiteralTree)expression).valueAsLong() < 65537L;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        private static boolean isNonCompliantCurveArgument(PyArgumentTree argument, int index, SubscriptionContext ctx) {
            PyNameTree keywordArgument = argument.keywordArgument();
            if (keywordArgument == null) {
                return index == 0 && CryptoAPICheck.isNonCompliantCurve(argument.expression(), ctx);
            }
            return keywordArgument.name().equals("curve") && CryptoAPICheck.isNonCompliantCurve(argument.expression(), ctx);
        }

        private static boolean isNonCompliantCurve(PyExpressionTree expression, SubscriptionContext ctx) {
            if (!expression.is(Tree.Kind.QUALIFIED_EXPR)) {
                return false;
            }
            PyQualifiedExpressionTree qualifiedExpressionTree = (PyQualifiedExpressionTree)expression;
            Symbol symbol = ctx.symbolTable().getSymbol(qualifiedExpressionTree.qualifier());
            if (symbol == null || !symbol.qualifiedName().equals("cryptography.hazmat.primitives.asymmetric.ec")) {
                return false;
            }
            return CRYPTOGRAPHY_FORBIDDEN_CURVE.matcher(qualifiedExpressionTree.name().name()).matches();
        }

        void checkArguments(SubscriptionContext ctx, List<PyArgumentTree> arguments) {
            int index = 0;
            for (PyArgumentTree argument : arguments) {
                if (this.isNonCompliantKeySizeArgument(argument, index)) {
                    ctx.addIssue((Tree)argument, "Use a key length of at least 2048 bits.");
                }
                if (this.isNonCompliantExponentArgument(argument, index)) {
                    ctx.addIssue((Tree)argument, "Use a public key exponent of at least 65537.");
                }
                if (!(this instanceof CryptographyModuleCheck) || !CryptoAPICheck.isNonCompliantCurveArgument(argument, index, ctx)) continue;
                ctx.addIssue((Tree)argument, "Use a key length of at least 224 bits.");
            }
        }
    }
}

