/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.ClassDef;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.metrics.ComplexityVisitor;

@Rule(key="ClassComplexity")
public class ClassComplexityCheck
extends PythonSubscriptionCheck {
    private static final int DEFAULT_MAXIMUM_CLASS_COMPLEXITY_THRESHOLD = 200;
    private static final String MESSAGE = "Class has a complexity of %s which is greater than %s authorized.";
    @RuleProperty(key="maximumClassComplexityThreshold", defaultValue="200")
    int maximumClassComplexityThreshold = 200;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            int complexity = ComplexityVisitor.complexity((Tree)classDef);
            if (complexity > this.maximumClassComplexityThreshold) {
                String message = String.format(MESSAGE, complexity, this.maximumClassComplexityThreshold);
                ctx.addIssue((Tree)classDef.name(), message).withCost(complexity - this.maximumClassComplexityThreshold);
            }
        });
    }
}

