/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.BinaryExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.NumericLiteral;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S1764")
public class IdenticalExpressionOnBinaryOperatorCheck
extends PythonSubscriptionCheck {
    private static final List<Tree.Kind> kinds = Arrays.asList(Tree.Kind.MINUS, Tree.Kind.DIVISION, Tree.Kind.FLOOR_DIVISION, Tree.Kind.MODULO, Tree.Kind.SHIFT_EXPR, Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_OR, Tree.Kind.BITWISE_XOR, Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.COMPARISON, Tree.Kind.IS, Tree.Kind.IN);

    public void initialize(SubscriptionCheck.Context context) {
        kinds.forEach(k -> context.registerSyntaxNodeConsumer(k, this::checkBinaryExpression));
    }

    private void checkBinaryExpression(SubscriptionContext ctx) {
        BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
        Expression leftOperand = binaryExpression.leftOperand();
        Expression rightOperand = binaryExpression.rightOperand();
        Token operator = binaryExpression.operator();
        if (CheckUtils.areEquivalent((Tree)leftOperand, (Tree)rightOperand) && !IdenticalExpressionOnBinaryOperatorCheck.isLeftShiftBy1(leftOperand, operator)) {
            ctx.addIssue((Tree)rightOperand, "Correct one of the identical sub-expressions on both sides of operator \"" + operator.value() + "\".").secondary((Tree)leftOperand, "");
        }
    }

    private static boolean isLeftShiftBy1(Expression leftOperand, Token operator) {
        return "<<".equals(operator.value()) && leftOperand.is(Tree.Kind.NUMERIC_LITERAL) && ((NumericLiteral)leftOperand).valueAsLong() == 1L;
    }
}

