/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.tree.BinaryExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;

@Rule(key="InequalityUsage")
public class InequalityUsageCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            BinaryExpression expr = (BinaryExpression)ctx.syntaxNode();
            Token operator = expr.operator();
            if (operator.value().equals(PythonPunctuator.NOT_EQU2.getValue())) {
                ctx.addIssue(operator, "Replace \"<>\" by \"!=\".");
            }
        });
    }
}

