/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.api.tree.ReturnStatement;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.YieldStatement;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S2734")
public class InitReturnsValueCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_RETURN = "Remove this return value.";
    private static final String MESSAGE_YIELD = "Remove this yield statement.";
    public static final String CHECK_KEY = "S2734";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef func = (FunctionDef)ctx.syntaxNode();
            if (!"__init__".equals(func.name().name())) {
                return;
            }
            ReturnAndYieldVisitor returnAndYieldVisitor = new ReturnAndYieldVisitor();
            func.body().accept((TreeVisitor)returnAndYieldVisitor);
            for (Tree returnNode : returnAndYieldVisitor.returnNodes) {
                String message = returnNode.is(Tree.Kind.RETURN_STMT) ? MESSAGE_RETURN : MESSAGE_YIELD;
                ctx.addIssue(returnNode, message);
            }
        });
    }

    private static class ReturnAndYieldVisitor
    extends BaseTreeVisitor {
        List<Tree> returnNodes = new ArrayList<Tree>();

        private ReturnAndYieldVisitor() {
        }

        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        }

        public void visitReturnStatement(ReturnStatement pyReturnStatementTree) {
            if (pyReturnStatementTree.expressions().isEmpty() || ((Expression)pyReturnStatementTree.expressions().get(0)).is(Tree.Kind.NONE)) {
                return;
            }
            this.returnNodes.add((Tree)pyReturnStatementTree);
        }

        public void visitYieldStatement(YieldStatement pyYieldStatementTree) {
            this.returnNodes.add((Tree)pyYieldStatementTree);
        }
    }
}

