/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.ExpressionStatement;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.Parameter;
import org.sonar.python.api.tree.ParameterList;
import org.sonar.python.api.tree.RaiseStatement;
import org.sonar.python.api.tree.Statement;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S2325")
public class MethodShouldBeStaticCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make this method static.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef funcDef = (FunctionDef)ctx.syntaxNode();
            if (!(!funcDef.isMethodDefinition() || CheckUtils.classHasInheritance(CheckUtils.getParentClassDef((Tree)funcDef)) || MethodShouldBeStaticCheck.isBuiltInMethod(funcDef) || MethodShouldBeStaticCheck.isStatic(funcDef) || !MethodShouldBeStaticCheck.hasValuableCode(funcDef) || MethodShouldBeStaticCheck.mayRaiseNotImplementedError(funcDef) || MethodShouldBeStaticCheck.isUsingSelfArg(funcDef))) {
                ctx.addIssue((Tree)funcDef.name(), MESSAGE);
            }
        });
    }

    private static boolean mayRaiseNotImplementedError(FunctionDef funcDef) {
        RaiseStatementVisitor visitor = new RaiseStatementVisitor();
        funcDef.accept((TreeVisitor)visitor);
        return visitor.hasNotImplementedError;
    }

    private static boolean hasValuableCode(FunctionDef funcDef) {
        List statements = funcDef.body().statements();
        return !statements.stream().allMatch(st -> MethodShouldBeStaticCheck.isStringLiteral(st) || st.is(Tree.Kind.PASS_STMT));
    }

    private static boolean isStringLiteral(Statement st) {
        return st.is(Tree.Kind.EXPRESSION_STMT) && ((ExpressionStatement)st).expressions().stream().allMatch(e -> e.is(Tree.Kind.STRING_LITERAL));
    }

    private static boolean isUsingSelfArg(FunctionDef funcDef) {
        ParameterList parameters = funcDef.parameters();
        if (parameters == null) {
            return true;
        }
        List params = parameters.nonTuple();
        if (params.isEmpty()) {
            return false;
        }
        Parameter first = (Parameter)params.get(0);
        SelfVisitor visitor = new SelfVisitor(first.name().name());
        funcDef.body().accept((TreeVisitor)visitor);
        return visitor.isUsingSelfArg;
    }

    private static boolean isStatic(FunctionDef funcDef) {
        return funcDef.decorators().stream().map(d -> (Name)d.name().names().get(d.name().names().size() - 1)).anyMatch(n -> n.name().equals("staticmethod") || n.name().equals("classmethod"));
    }

    private static boolean isBuiltInMethod(FunctionDef funcDef) {
        String doubleUnderscore;
        String name = funcDef.name().name();
        return name.startsWith(doubleUnderscore = "__") && name.endsWith(doubleUnderscore);
    }

    private static class SelfVisitor
    extends BaseTreeVisitor {
        private final String selfName;
        boolean isUsingSelfArg = false;

        SelfVisitor(String selfName) {
            this.selfName = selfName;
        }

        public void visitName(Name pyNameTree) {
            this.isUsingSelfArg |= this.selfName.equals(pyNameTree.name());
        }
    }

    private static class RaiseStatementVisitor
    extends BaseTreeVisitor {
        private int withinRaise = 0;
        boolean hasNotImplementedError = false;

        private RaiseStatementVisitor() {
        }

        public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
            ++this.withinRaise;
            this.scan(pyRaiseStatementTree.expressions());
            --this.withinRaise;
        }

        public void visitName(Name pyNameTree) {
            if (this.withinRaise > 0) {
                this.hasNotImplementedError |= pyNameTree.name().equals("NotImplementedError");
            }
        }
    }
}

