/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonCheckTree;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.tree.ForStatement;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.TryStatement;
import org.sonar.python.api.tree.WhileStatement;
import org.sonar.python.api.tree.WithStatement;

@Rule(key="S134")
public class NestedControlFlowDepthCheck
extends PythonCheckTree {
    private static final int DEFAULT_MAX = 4;
    private static final String MESSAGE = "Refactor this code to not nest more than %s \"if\", \"for\", \"while\", \"try\" and \"with\" statements.";
    @RuleProperty(key="max", defaultValue="4")
    public int max = 4;
    private Deque<Token> depthNodes = new ArrayDeque<Token>();

    public void scanFile(PythonVisitorContext visitorContext) {
        this.depthNodes.clear();
        super.scanFile(visitorContext);
    }

    public void visitIfStatement(IfStatement pyIfStatementTree) {
        Token keyword = pyIfStatementTree.keyword();
        boolean isIFKeyword = keyword.type().equals(PythonKeyword.IF);
        if (isIFKeyword) {
            this.depthNodes.push(keyword);
            this.checkNode();
        }
        super.visitIfStatement(pyIfStatementTree);
        if (isIFKeyword) {
            this.depthNodes.pop();
        }
    }

    public void visitForStatement(ForStatement pyForStatementTree) {
        this.depthNodes.push(pyForStatementTree.forKeyword());
        this.checkNode();
        super.visitForStatement(pyForStatementTree);
        this.depthNodes.pop();
    }

    public void visitWhileStatement(WhileStatement pyWhileStatementTree) {
        this.depthNodes.push(pyWhileStatementTree.whileKeyword());
        this.checkNode();
        super.visitWhileStatement(pyWhileStatementTree);
        this.depthNodes.pop();
    }

    public void visitTryStatement(TryStatement pyTryStatementTree) {
        this.depthNodes.push(pyTryStatementTree.tryKeyword());
        this.checkNode();
        super.visitTryStatement(pyTryStatementTree);
        this.depthNodes.pop();
    }

    public void visitWithStatement(WithStatement pyWithStatementTree) {
        this.depthNodes.push(pyWithStatementTree.firstToken());
        this.checkNode();
        super.visitWithStatement(pyWithStatementTree);
        this.depthNodes.pop();
    }

    private void checkNode() {
        if (this.depthNodes.size() == this.max + 1) {
            Token lastToken = this.depthNodes.peek();
            PythonCheck.PreciseIssue issue = this.addIssue(lastToken, String.format(MESSAGE, this.max));
            Iterator<Token> depthNodesIterator = this.depthNodes.iterator();
            depthNodesIterator.next();
            while (depthNodesIterator.hasNext()) {
                issue.secondary(depthNodesIterator.next(), "Nesting +1");
            }
        }
    }
}

