/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.ConditionalExpression;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.ParenthesizedExpression;
import org.sonar.python.api.tree.Statement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S1871")
public class SameBranchCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Either merge this branch with the identical one on line \"%s\" or change one of the implementations.";
    private List<Tree> ignoreList;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.ignoreList = new ArrayList<Tree>();
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> {
            IfStatement ifStmt = (IfStatement)ctx.syntaxNode();
            if (this.ignoreList.contains(ifStmt)) {
                return;
            }
            List<StatementList> branches = this.getIfBranches(ifStmt);
            SameBranchCheck.findSameBranches(branches, ctx);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, ctx -> {
            ConditionalExpression conditionalExpression = (ConditionalExpression)ctx.syntaxNode();
            if (this.ignoreList.contains(conditionalExpression)) {
                return;
            }
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            this.addConditionalExpressionBranches(expressions, conditionalExpression);
            SameBranchCheck.findSameBranches(expressions, ctx);
        });
    }

    private static void findSameBranches(List<? extends Tree> branches, SubscriptionContext ctx) {
        for (int i = 1; i < branches.size(); ++i) {
            SameBranchCheck.checkBranches(branches, i, ctx);
        }
    }

    private static void checkBranches(List<? extends Tree> branches, int index, SubscriptionContext ctx) {
        Tree duplicateBlock = branches.get(index);
        boolean isOnASingleLine = SameBranchCheck.isOnASingleLine(duplicateBlock);
        ArrayList<Tree> equivalentBlocks = new ArrayList<Tree>();
        for (int j = 0; j < index; ++j) {
            boolean allBranchesIdentical;
            Tree originalBlock = branches.get(j);
            if (!CheckUtils.areEquivalent(originalBlock, duplicateBlock)) continue;
            equivalentBlocks.add(originalBlock);
            boolean bl = allBranchesIdentical = equivalentBlocks.size() == branches.size() - 1;
            if (isOnASingleLine && !allBranchesIdentical) continue;
            int line = SameBranchCheck.getFirstToken(originalBlock).line();
            String message = String.format(MESSAGE, line);
            PythonCheck.PreciseIssue issue = ctx.addIssue(SameBranchCheck.getFirstToken(duplicateBlock), SameBranchCheck.getLastToken(duplicateBlock), message);
            equivalentBlocks.forEach(e -> issue.secondary(SameBranchCheck.getFirstToken(e), "Original"));
        }
    }

    private List<StatementList> getIfBranches(IfStatement ifStmt) {
        ArrayList<StatementList> branches = new ArrayList<StatementList>();
        branches.add(ifStmt.body());
        branches.addAll(ifStmt.elifBranches().stream().map(IfStatement::body).collect(Collectors.toList()));
        ElseStatement elseStatement = ifStmt.elseBranch();
        if (elseStatement != null) {
            branches.add(elseStatement.body());
            this.lookForElseIfs(branches, elseStatement);
        }
        return branches;
    }

    private void addConditionalExpressionBranches(List<Expression> branches, ConditionalExpression conditionalExpression) {
        Expression trueExpression = SameBranchCheck.removeParentheses(conditionalExpression.trueExpression());
        Expression falseExpression = SameBranchCheck.removeParentheses(conditionalExpression.falseExpression());
        if (trueExpression.is(Tree.Kind.CONDITIONAL_EXPR)) {
            this.ignoreList.add((Tree)trueExpression);
            this.addConditionalExpressionBranches(branches, (ConditionalExpression)trueExpression);
        } else {
            branches.add(trueExpression);
        }
        if (falseExpression.is(Tree.Kind.CONDITIONAL_EXPR)) {
            this.ignoreList.add((Tree)falseExpression);
            this.addConditionalExpressionBranches(branches, (ConditionalExpression)falseExpression);
        } else {
            branches.add(falseExpression);
        }
    }

    private static Expression removeParentheses(Expression expression) {
        if (expression.is(Tree.Kind.PARENTHESIZED)) {
            return SameBranchCheck.removeParentheses(((ParenthesizedExpression)expression).expression());
        }
        return expression;
    }

    private void lookForElseIfs(List<StatementList> branches, ElseStatement elseBranch) {
        IfStatement singleIfChild = SameBranchCheck.singleIfChild(elseBranch.body());
        if (singleIfChild != null) {
            this.ignoreList.add((Tree)singleIfChild);
            branches.addAll(this.getIfBranches(singleIfChild));
        }
    }

    private static IfStatement singleIfChild(StatementList statementList) {
        List statements = statementList.statements();
        if (statements.size() == 1 && ((Statement)statements.get(0)).is(Tree.Kind.IF_STMT)) {
            return (IfStatement)statements.get(0);
        }
        return null;
    }

    private static boolean isOnASingleLine(Tree tree) {
        if (tree.is(Tree.Kind.STATEMENT_LIST)) {
            StatementList duplicateBlock = (StatementList)tree;
            return ((Statement)duplicateBlock.statements().get(0)).firstToken().line() == ((Statement)duplicateBlock.statements().get(duplicateBlock.statements().size() - 1)).lastToken().line();
        }
        return tree.firstToken().line() == tree.lastToken().line();
    }

    private static Token getFirstToken(Tree tree) {
        if (tree.is(Tree.Kind.STATEMENT_LIST)) {
            return SameBranchCheck.getFirstToken((Tree)((StatementList)tree).statements().get(0));
        }
        return tree.firstToken();
    }

    private static Token getLastToken(Tree tree) {
        if (tree.is(Tree.Kind.STATEMENT_LIST)) {
            List statements = ((StatementList)tree).statements();
            return SameBranchCheck.getLastToken((Tree)statements.get(statements.size() - 1));
        }
        return tree.lastToken();
    }
}

