/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.Statement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S1862")
public class SameConditionCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1862";
    private static final String MESSAGE = "This branch duplicates the one on line %s.";
    private List<IfStatement> ignoreList;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.ignoreList = new ArrayList<IfStatement>();
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> {
            IfStatement ifStatement = (IfStatement)ctx.syntaxNode();
            if (this.ignoreList.contains(ifStatement)) {
                return;
            }
            List<Expression> conditions = this.getConditionsToCompare(ifStatement);
            this.findSameConditions(conditions, (SubscriptionContext)ctx);
        });
    }

    private List<Expression> getConditionsToCompare(IfStatement ifStatement) {
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        conditions.add(ifStatement.condition());
        conditions.addAll(ifStatement.elifBranches().stream().map(IfStatement::condition).collect(Collectors.toList()));
        ElseStatement elseStatement = ifStatement.elseBranch();
        if (elseStatement != null) {
            this.lookForElseIfs(conditions, elseStatement);
        }
        return conditions;
    }

    private void lookForElseIfs(List<Expression> conditions, ElseStatement elseBranch) {
        IfStatement singleIfChild = SameConditionCheck.singleIfChild(elseBranch.body());
        if (singleIfChild != null) {
            this.ignoreList.add(singleIfChild);
            conditions.addAll(this.getConditionsToCompare(singleIfChild));
        }
    }

    private void findSameConditions(List<Expression> conditions, SubscriptionContext ctx) {
        for (int i = 1; i < conditions.size(); ++i) {
            this.compareConditions(conditions, i, ctx);
        }
    }

    private void compareConditions(List<Expression> conditions, int index, SubscriptionContext ctx) {
        for (int j = 0; j < index; ++j) {
            if (!CheckUtils.areEquivalent((Tree)conditions.get(j), (Tree)conditions.get(index))) continue;
            String message = String.format(MESSAGE, conditions.get(j).firstToken().line());
            ctx.addIssue((Tree)conditions.get(index), message).secondary((Tree)conditions.get(j), "Original");
            return;
        }
    }

    private static IfStatement singleIfChild(StatementList statementList) {
        List statements = statementList.statements();
        if (statements.size() == 1 && ((Statement)statements.get(0)).is(Tree.Kind.IF_STMT)) {
            return (IfStatement)statements.get(0);
        }
        return null;
    }
}

