/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S104")
public class TooManyLinesInFileCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S104";
    private static final int DEFAULT = 1000;
    private static final String MESSAGE = "File \"{0}\" has {1} lines, which is greater than {2} authorized. Split it into smaller files.";
    @RuleProperty(key="maximum", defaultValue="1000")
    public int maximum = 1000;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            FileVisitor visitor = new FileVisitor();
            ctx.syntaxNode().accept((TreeVisitor)visitor);
            if (visitor.numberOfLines > this.maximum) {
                ctx.addFileIssue(MessageFormat.format(MESSAGE, ctx.pythonFile().fileName(), visitor.numberOfLines, this.maximum));
            }
        });
    }

    private static class FileVisitor
    extends BaseTreeVisitor {
        private int numberOfLines = 0;

        private FileVisitor() {
        }

        public void visitFileInput(FileInput fileInput) {
            if (fileInput.statements() != null) {
                this.numberOfLines = ((Token)fileInput.statements().tokens().get(fileInput.statements().tokens().size() - 1)).line();
            }
        }
    }
}

