/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.ForStatement;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.StringElement;
import org.sonar.python.api.tree.StringLiteral;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.Usage;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PythonSubscriptionCheck {
    private static final Pattern INTERPOLATION_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final String MESSAGE = "Remove the unused local variable \"%s\".";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionTree = (FunctionDef)ctx.syntaxNode();
            if (UnusedLocalVariableCheck.isCallingLocalsFunction(functionTree)) {
                return;
            }
            Set<String> interpolationIdentifiers = UnusedLocalVariableCheck.extractStringInterpolationIdentifiers(functionTree);
            for (Symbol symbol : functionTree.localVariables()) {
                if (!interpolationIdentifiers.stream().noneMatch(id -> id.contains(symbol.name())) || "_".equals(symbol.name()) || !UnusedLocalVariableCheck.hasOnlyBindingUsages(symbol)) continue;
                symbol.usages().stream().filter(usage -> usage.tree().parent() == null || !usage.tree().parent().is(Tree.Kind.PARAMETER)).filter(usage -> !UnusedLocalVariableCheck.isTupleDeclaration(usage.tree())).forEach(usage -> ctx.addIssue(usage.tree(), String.format(MESSAGE, symbol.name())));
            }
        });
    }

    private static boolean hasOnlyBindingUsages(Symbol symbol) {
        List usages = symbol.usages();
        return usages.stream().noneMatch(usage -> usage.kind() == Usage.Kind.IMPORT) && usages.stream().allMatch(Usage::isBindingUsage);
    }

    private static boolean isTupleDeclaration(Tree tree) {
        return tree.ancestors().stream().anyMatch(t -> t.is(Tree.Kind.TUPLE) || t.is(Tree.Kind.EXPRESSION_LIST) && ((ExpressionList)t).expressions().size() > 1 || t.is(Tree.Kind.FOR_STMT) && ((ForStatement)t).expressions().size() > 1 && ((ForStatement)t).expressions().contains(tree));
    }

    private static boolean isCallingLocalsFunction(FunctionDef functionTree) {
        return functionTree.descendants(Tree.Kind.CALL_EXPR).map(CallExpression.class::cast).map(CallExpression::callee).anyMatch(callee -> callee.is(Tree.Kind.NAME) && "locals".equals(((Name)callee).name()));
    }

    private static Set<String> extractStringInterpolationIdentifiers(FunctionDef functionTree) {
        return functionTree.descendants(Tree.Kind.STRING_LITERAL).map(StringLiteral.class::cast).flatMap(str -> str.stringElements().stream()).filter(str -> str.prefix().equalsIgnoreCase("f")).map(StringElement::trimmedQuotesValue).flatMap(UnusedLocalVariableCheck::extractInterpolations).collect(Collectors.toSet());
    }

    private static Stream<String> extractInterpolations(String str) {
        Matcher matcher = INTERPOLATION_PATTERN.matcher(str);
        ArrayList<String> identifiers = new ArrayList<String>();
        while (matcher.find()) {
            identifiers.add(matcher.group(1));
        }
        return identifiers.stream();
    }
}

