/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.AssignmentStatement;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.QualifiedExpression;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4507")
public class DebugModeCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S4507";
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final List<String> debugProperties = Arrays.asList("DEBUG", "DEBUG_PROPAGATE_EXCEPTIONS");
    private static final List<String> settingFiles = Arrays.asList("global_settings.py", "settings.py");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            List arguments = callExpression.arguments();
            if (!(callExpression.callee() instanceof QualifiedExpression)) {
                return;
            }
            if ("django.conf.settings.configure".equals(DebugModeCheck.getQualifiedName(callExpression)) && !arguments.isEmpty()) {
                arguments.stream().filter(DebugModeCheck::isDebugArgument).forEach(arg -> ctx.addIssue((Tree)arg, MESSAGE));
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            if (!settingFiles.contains(ctx.pythonFile().fileName())) {
                return;
            }
            AssignmentStatement assignmentStatementTree = (AssignmentStatement)ctx.syntaxNode();
            for (ExpressionList lhsExpression : assignmentStatementTree.lhsExpressions()) {
                boolean isDebugProperties = lhsExpression.expressions().stream().anyMatch(DebugModeCheck::isDebugIdentifier);
                if (!isDebugProperties || !DebugModeCheck.isTrueLiteral(assignmentStatementTree.assignedValue())) continue;
                ctx.addIssue((Tree)assignmentStatementTree, MESSAGE);
            }
        });
    }

    private static boolean isDebugIdentifier(Expression expr) {
        return expr.is(Tree.Kind.NAME) && debugProperties.contains(((Name)expr).name());
    }

    private static boolean isTrueLiteral(Expression expr) {
        return expr.is(Tree.Kind.NAME) && ((Name)expr).name().equals("True");
    }

    private static boolean isDebugArgument(Argument argument) {
        Name keywordArgument = argument.keywordArgument();
        if (keywordArgument != null && debugProperties.contains(keywordArgument.name())) {
            return DebugModeCheck.isTrueLiteral(argument.expression());
        }
        return false;
    }

    @CheckForNull
    private static String getQualifiedName(CallExpression callExpression) {
        Symbol symbol = callExpression.calleeSymbol();
        return symbol != null ? symbol.fullyQualifiedName() : "";
    }
}

