/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.DictionaryLiteral;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.KeyValuePair;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.StringLiteral;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.semantic.Symbol;

@Rule(key="S5439")
public class DisabledHtmlAutoEscapeCheck
extends PythonSubscriptionCheck {
    private static final String AUTO_ESCAPE = "autoescape";
    private static final String MESSAGE = "Remove this configuration disabling autoescape globally.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> DisabledHtmlAutoEscapeCheck.checkCallExpression(ctx, (CallExpression)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.KEY_VALUE_PAIR, ctx -> DisabledHtmlAutoEscapeCheck.checkKeyValuePair(ctx, (KeyValuePair)ctx.syntaxNode()));
    }

    private static void checkKeyValuePair(SubscriptionContext ctx, KeyValuePair keyValue) {
        if (!"settings.py".equals(ctx.pythonFile().fileName())) {
            return;
        }
        if (DisabledHtmlAutoEscapeCheck.isStringLiteral(keyValue.key(), AUTO_ESCAPE) && Expressions.isFalsy(keyValue.value())) {
            ctx.addIssue((Tree)keyValue, MESSAGE);
        }
    }

    private static boolean isStringLiteral(@Nullable Expression tree, String testedValue) {
        return tree != null && tree.is(Tree.Kind.STRING_LITERAL) && testedValue.equals(((StringLiteral)tree).trimmedQuotesValue());
    }

    private static void checkCallExpression(SubscriptionContext ctx, CallExpression call) {
        Symbol symbol = call.calleeSymbol();
        if (symbol != null && "jinja2.Environment".equals(symbol.fullyQualifiedName())) {
            List arguments = call.arguments();
            for (Argument argument : arguments) {
                Expression expression = argument.expression();
                if (!expression.is(Tree.Kind.NAME) || argument.starStarToken() == null) continue;
                DisabledHtmlAutoEscapeCheck.checkJinjaOptions(ctx, call, (Name)expression);
                return;
            }
            Stream<Argument> autoEscapeArgs = arguments.stream().filter(DisabledHtmlAutoEscapeCheck::isAutoEscapeArgument);
            if (autoEscapeArgs.allMatch(arg -> Expressions.isFalsy(arg.expression()))) {
                ctx.addIssue((Tree)call, MESSAGE);
            }
        }
    }

    private static void checkJinjaOptions(SubscriptionContext ctx, CallExpression call, Name expression) {
        DictionaryLiteral dict;
        Optional<Expression> autoEscapeOption;
        Expression options = Expressions.singleAssignedValue(expression);
        if (options != null && options.is(Tree.Kind.DICTIONARY_LITERAL) && (!(autoEscapeOption = (dict = (DictionaryLiteral)options).elements().stream().filter(kv -> DisabledHtmlAutoEscapeCheck.isStringLiteral(kv.key(), AUTO_ESCAPE)).map(KeyValuePair::value).findFirst()).isPresent() || Expressions.isFalsy(autoEscapeOption.get()))) {
            ctx.addIssue((Tree)call, MESSAGE);
        }
    }

    private static boolean isAutoEscapeArgument(Argument argument) {
        Name keyword = argument.keywordArgument();
        return keyword != null && AUTO_ESCAPE.equals(keyword.name());
    }
}

