/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.Tree;

@Rule(key="S1523")
public class DynamicCodeExecutionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure that this dynamic injection or execution of code is safe.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpr = (CallExpression)ctx.syntaxNode();
            if (DynamicCodeExecutionCheck.isFuncNameExecOrEval(callExpr)) {
                ctx.addIssue((Tree)callExpr, MESSAGE);
            }
        });
    }

    private static boolean isFuncNameExecOrEval(CallExpression call) {
        Expression expr = call.callee();
        if (expr.is(Tree.Kind.NAME)) {
            String functionName = ((Name)expr).name();
            return functionName.equals("exec") || functionName.equals("eval");
        }
        return false;
    }
}

