/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.ArgList;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.AssignmentStatement;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.ClassDef;
import org.sonar.python.api.tree.HasSymbol;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4792")
public class LoggersConfigurationCheck
extends PythonSubscriptionCheck {
    private static final List<String> FUNCTIONS_TO_CHECK = Arrays.asList("logging.basicConfig", "logging.disable", "logging.setLoggerClass", "logging.config.fileConfig", "logging.config.dictConfig");
    private static final List<String> LOGGERS_CLASSES = Arrays.asList("logging.Logger", "logging.Handler", "logging.Filter");
    private static final String MESSAGE = "Make sure that this logger's configuration is safe.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpressionTree = (CallExpression)ctx.syntaxNode();
            Symbol symbol = callExpressionTree.calleeSymbol();
            if (symbol != null && FUNCTIONS_TO_CHECK.contains(symbol.fullyQualifiedName())) {
                ctx.addIssue((Tree)callExpressionTree, MESSAGE);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> LoggersConfigurationCheck.isSettingLastResort(ctx, (AssignmentStatement)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> LoggersConfigurationCheck.isClassExtendingLogger(ctx, (ClassDef)ctx.syntaxNode()));
    }

    private static void isClassExtendingLogger(SubscriptionContext ctx, ClassDef classDef) {
        ArgList argList = classDef.args();
        if (argList != null) {
            argList.arguments().stream().map(Argument::expression).filter(expr -> expr instanceof HasSymbol && ((HasSymbol)expr).symbol() != null).filter(expr -> LOGGERS_CLASSES.contains(((HasSymbol)expr).symbol().fullyQualifiedName())).forEach(expr -> ctx.addIssue((Tree)expr, MESSAGE));
        }
    }

    private static void isSettingLastResort(SubscriptionContext ctx, AssignmentStatement assignment) {
        assignment.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).forEach(expr -> {
            Symbol symbol;
            if (expr instanceof HasSymbol && (symbol = ((HasSymbol)expr).symbol()) != null && "logging.lastResort".equals(symbol.fullyQualifiedName())) {
                ctx.addIssue((Tree)expr, MESSAGE);
            }
        });
    }
}

