/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

@Rule(key="S2245")
public class PseudoRandomCheck
extends PythonSubscriptionCheck {
    private static final Set<String> FUNCTIONS_TO_CHECK = new HashSet<String>(Arrays.asList("random.random", "random.getrandbits", "random.randint", "random.sample", "random.choice", "random.choices"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol symbol = callExpression.calleeSymbol();
            if (symbol != null && FUNCTIONS_TO_CHECK.contains(symbol.fullyQualifiedName())) {
                ctx.addIssue((Tree)callExpression, "Make sure that using this pseudorandom number generator is safe here.");
            }
        });
    }
}

