/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.BinaryExpression;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.QualifiedExpression;
import org.sonar.python.api.tree.StringLiteral;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S2077")
public class SQLQueriesCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S2077";
    private static final String MESSAGE = "Make sure that formatting this SQL query is safe here.";
    private boolean isUsingDjangoModel = false;
    private boolean isUsingDjangoDBConnection = false;

    @Override
    protected Set<String> functionsToCheck() {
        return Collections.singleton("django.db.models.expressions.RawSQL");
    }

    @Override
    protected String message() {
        return MESSAGE;
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        super.initialize(context);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::visitFile);
    }

    private void visitFile(SubscriptionContext ctx) {
        this.isUsingDjangoModel = false;
        this.isUsingDjangoDBConnection = false;
        FileInput tree = (FileInput)ctx.syntaxNode();
        List symbols = tree.descendants().filter(node -> node.is(Tree.Kind.IMPORT_FROM) || node.is(Tree.Kind.IMPORT_NAME)).flatMap(node -> node.descendants(Tree.Kind.NAME)).map(node -> ((Name)node).symbol()).filter(Objects::nonNull).collect(Collectors.toList());
        for (Symbol symbol : symbols) {
            String qualifiedName;
            String string = qualifiedName = symbol.fullyQualifiedName() != null ? symbol.fullyQualifiedName() : "";
            if (qualifiedName.contains("django.db.models")) {
                this.isUsingDjangoModel = true;
            }
            if (!qualifiedName.contains("django.db.connection")) continue;
            this.isUsingDjangoDBConnection = true;
        }
    }

    private boolean isSQLQueryFromDjangoModel(String functionName) {
        return this.isUsingDjangoModel && (functionName.equals("raw") || functionName.equals("extra"));
    }

    private boolean isSQLQueryFromDjangoDBConnection(String functionName) {
        return this.isUsingDjangoDBConnection && functionName.equals("execute");
    }

    @Override
    public void visitNode(SubscriptionContext context) {
        String functionName;
        CallExpression callExpressionTree = (CallExpression)context.syntaxNode();
        if (callExpressionTree.callee().is(Tree.Kind.QUALIFIED_EXPR) && (this.isSQLQueryFromDjangoModel(functionName = ((QualifiedExpression)callExpressionTree.callee()).name().name()) || this.isSQLQueryFromDjangoDBConnection(functionName)) && !SQLQueriesCheck.isException(callExpressionTree, functionName)) {
            context.addIssue((Tree)callExpressionTree, MESSAGE);
        }
        super.visitNode(context);
    }

    private static boolean isException(CallExpression callExpression, String functionName) {
        List argListNode = callExpression.arguments();
        if (SQLQueriesCheck.extraContainsFormattedSqlQueries(argListNode, functionName)) {
            return false;
        }
        if (argListNode.isEmpty()) {
            return true;
        }
        Argument arg = (Argument)argListNode.get(0);
        return !SQLQueriesCheck.isFormatted(arg.expression());
    }

    @Override
    protected boolean isException(CallExpression callExpression) {
        return SQLQueriesCheck.isException(callExpression, "");
    }

    private static boolean isFormatted(Expression tree) {
        FormattedStringVisitor visitor = new FormattedStringVisitor();
        tree.accept((TreeVisitor)visitor);
        return visitor.hasFormattedString;
    }

    private static boolean extraContainsFormattedSqlQueries(List<Argument> argListNode, String functionName) {
        if (functionName.equals("extra")) {
            return argListNode.stream().filter(SQLQueriesCheck::isAssignment).map(Argument::expression).anyMatch(SQLQueriesCheck::isFormatted);
        }
        return false;
    }

    private static boolean isAssignment(Argument arg) {
        return arg.equalToken() != null;
    }

    private static class FormattedStringVisitor
    extends BaseTreeVisitor {
        boolean hasFormattedString = false;

        private FormattedStringVisitor() {
        }

        public void visitStringLiteral(StringLiteral pyStringLiteralTree) {
            super.visitStringLiteral(pyStringLiteralTree);
            this.hasFormattedString |= pyStringLiteralTree.stringElements().stream().anyMatch(se -> se.prefix().equalsIgnoreCase("f"));
        }

        public void visitCallExpression(CallExpression pyCallExpressionTree) {
            if (pyCallExpressionTree.callee().is(Tree.Kind.QUALIFIED_EXPR)) {
                QualifiedExpression callee = (QualifiedExpression)pyCallExpressionTree.callee();
                this.hasFormattedString |= callee.name().name().equals("format") && callee.qualifier().is(Tree.Kind.STRING_LITERAL);
            }
            super.visitCallExpression(pyCallExpressionTree);
        }

        public void visitBinaryExpression(BinaryExpression pyBinaryExpressionTree) {
            this.hasFormattedString |= pyBinaryExpressionTree.leftOperand().is(Tree.Kind.STRING_LITERAL) || pyBinaryExpressionTree.rightOperand().is(Tree.Kind.STRING_LITERAL);
            super.visitBinaryExpression(pyBinaryExpressionTree);
        }
    }
}

