/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4829")
public class StandardInputCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S4829";
    private static final String MESSAGE = "Make sure that reading the standard input is safe here.";
    private static final Set<String> fileInputFunctions = StandardInputCheck.immutableSet("fileinput.input", "fileinput.FileInput");
    private static final Set<String> sysFunctions = StandardInputCheck.immutableSet("sys.stdin.read", "sys.stdin.readline", "sys.stdin.readlines", "sys.__stdin__.read", "sys.__stdin__.readline", "sys.__stdin__.readlines");
    private static final Set<String> questionableFunctionsBuiltIn = StandardInputCheck.immutableSet("raw_input", "input");
    private static final Set<String> questionablePropertyAccess = StandardInputCheck.immutableSet("sys.stdin", "sys.__stdin__");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpr = (CallExpression)ctx.syntaxNode();
            if (questionableFunctionsBuiltIn.contains(StandardInputCheck.getFunctionName(callExpr.callee()))) {
                ctx.addIssue((Tree)callExpr, this.message());
            } else {
                this.visitNode((SubscriptionContext)ctx);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, ctx -> {
            Name node = (Name)ctx.syntaxNode();
            if (StandardInputCheck.isWithinImport((Tree)node)) {
                return;
            }
            if (StandardInputCheck.isQuestionablePropertyAccess(node)) {
                ctx.addIssue((Tree)node, this.message());
            }
        });
    }

    private static String getFunctionName(Expression expr) {
        String functionName = "";
        if (expr.is(Tree.Kind.NAME)) {
            functionName = ((Name)expr).name();
        }
        return functionName;
    }

    @Override
    protected boolean isException(CallExpression callExpression) {
        Symbol symbol = callExpression.calleeSymbol();
        return symbol != null && fileInputFunctions.contains(symbol.fullyQualifiedName()) && !callExpression.arguments().isEmpty();
    }

    private static boolean isQuestionablePropertyAccess(Name pyNameTree) {
        CallExpression call;
        Optional<Tree> callExpression = pyNameTree.ancestors().stream().filter(tree -> tree.is(Tree.Kind.CALL_EXPR)).findFirst();
        if (callExpression.isPresent() && (call = (CallExpression)callExpression.get()).callee().descendants().anyMatch(tree -> tree == pyNameTree)) {
            return false;
        }
        Symbol symbol = pyNameTree.symbol();
        return symbol != null && questionablePropertyAccess.contains(symbol.fullyQualifiedName());
    }

    @Override
    protected Set<String> functionsToCheck() {
        return Stream.concat(fileInputFunctions.stream(), sysFunctions.stream()).collect(Collectors.toSet());
    }

    @Override
    protected String message() {
        return MESSAGE;
    }
}

