/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="ClassComplexity", priority=Priority.MAJOR, name="Classes should not be too complex", tags={"brain-overload"})
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point over the threshold")
public class ClassComplexityCheck
extends PythonCheck {
    public static final String CHECK_KEY = "ClassComplexity";
    private static final int DEFAULT_MAXIMUM_CLASS_COMPLEXITY_THRESHOLD = 200;
    private static final String MESSAGE = "Class has a complexity of %s which is greater than %s authorized.";
    @RuleProperty(key="maximumClassComplexityThreshold", defaultValue="200")
    private int maximumClassComplexityThreshold = 200;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void leaveNode(AstNode node) {
        SourceClass sourceClass = (SourceClass)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceClass, (MetricDef)PythonMetric.COMPLEXITY);
        if (complexity > this.maximumClassComplexityThreshold) {
            String message = String.format(MESSAGE, complexity, this.maximumClassComplexityThreshold);
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}), message);
        }
    }

    public void setMaximumClassComplexityThreshold(int threshold) {
        this.maximumClassComplexityThreshold = threshold;
    }
}

