/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1066", priority=Priority.MAJOR, name="Collapsible \"if\" statements should be merged", tags={"clumsy"})
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class CollapsibleIfStatementsCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1066";
    private static final String MESSAGE = "Merge this if statement with the enclosing one.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.IF_STMT});
    }

    public void visitNode(AstNode node) {
        AstNode suite = node.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        if (suite.getPreviousSibling().getPreviousSibling().is(new AstNodeType[]{PythonKeyword.ELSE})) {
            return;
        }
        AstNode singleIfChild = CollapsibleIfStatementsCheck.singleIfChild(suite);
        if (singleIfChild != null && !CollapsibleIfStatementsCheck.hasElseOrElif(singleIfChild)) {
            this.addIssue(singleIfChild.getToken(), MESSAGE).secondary(node.getFirstChild(), "enclosing");
        }
    }

    private static boolean hasElseOrElif(AstNode ifNode) {
        return ifNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.ELIF}) || ifNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.ELSE});
    }

    private static AstNode singleIfChild(AstNode suite) {
        AstSelect nestedIf;
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1 && (nestedIf = ((AstNode)statements.get(0)).select().children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.IF_STMT)).size() == 1) {
            return nestedIf.get(0);
        }
        return null;
    }
}

