/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.base.Strings;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.squidbridge.annotations.NoSqale;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="CommentRegularExpression", priority=Priority.MAJOR, name="Regular expression on comment")
@NoSqale
@RuleTemplate
public class CommentRegularExpressionCheck
extends PythonCheck
implements AstAndTokenVisitor {
    public static final String CHECK_KEY = "CommentRegularExpression";
    private static final String DEFAULT_REGULAR_EXPRESSION = "";
    private static final String DEFAULT_MESSAGE = "The regular expression matches this comment";
    private Pattern pattern = null;
    @RuleProperty(key="regularExpression", defaultValue="")
    public String regularExpression = "";
    @RuleProperty(key="message", defaultValue="The regular expression matches this comment")
    public String message = "The regular expression matches this comment";

    public void init() {
        if (!Strings.isNullOrEmpty((String)this.regularExpression)) {
            try {
                this.pattern = Pattern.compile(this.regularExpression, 32);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to compile regular expression: " + this.regularExpression, e);
            }
        }
    }

    public void visitToken(Token token) {
        if (this.pattern != null) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment() || !this.pattern.matcher(trivia.getToken().getOriginalValue()).matches()) continue;
                this.addIssue(trivia.getToken(), this.message);
            }
        }
    }
}

