/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;

@Rule(key="S1720", priority=Priority.MAJOR, name="Docstrings should be defined")
@SqaleConstantRemediation(value="5min")
public class MissingDocstringCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1720";
    private static final Pattern EMPTY_STRING_REGEXP = Pattern.compile("([bruBRU]+)?('\\s*')|(\"\\s*\")|('''\\s*''')|(\"\"\"\\s*\"\"\")");
    private static final String MESSAGE_NO_DOCSTRING = "Add a docstring to this %s.";
    private static final String MESSAGE_EMPTY_DOCSTRING = "The docstring for this %s should not be empty.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FILE_INPUT, PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.FILE_INPUT})) {
            this.visitModule(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            this.visitFuncDef(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
            this.visitClassDef(astNode);
        }
    }

    private void visitModule(AstNode astNode) {
        AstNode firstStatement = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        AstNode firstSimpleStmt = null;
        if (firstStatement != null) {
            firstSimpleStmt = MissingDocstringCheck.firstSimpleStmt(firstStatement);
        }
        this.checkSimpleStmt(astNode, firstSimpleStmt, DeclarationType.MODULE);
    }

    private void visitClassDef(AstNode astNode) {
        this.checkFirstSuite(astNode, DeclarationType.CLASS);
    }

    private void visitFuncDef(AstNode astNode) {
        if (!CheckUtils.isMethodDefinition(astNode)) {
            this.checkFirstSuite(astNode, DeclarationType.FUNCTION);
        } else {
            this.checkFirstSuite(astNode, DeclarationType.METHOD);
        }
    }

    private void checkFirstSuite(AstNode astNode, DeclarationType type) {
        AstNode suite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode firstStatement = suite.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        AstNode firstSimpleStmt = firstStatement == null ? suite.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST}).getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}) : MissingDocstringCheck.firstSimpleStmt(firstStatement);
        this.checkSimpleStmt(astNode, firstSimpleStmt, type);
    }

    private void checkSimpleStmt(AstNode astNode, @Nullable AstNode firstSimpleStmt, DeclarationType type) {
        if (firstSimpleStmt != null) {
            this.visitFirstStatement(astNode, firstSimpleStmt, type);
        } else {
            this.raiseIssueNoDocstring(astNode, type);
        }
    }

    private void raiseIssueNoDocstring(AstNode astNode, DeclarationType type) {
        if (type != DeclarationType.METHOD) {
            this.raiseIssue(astNode, MESSAGE_NO_DOCSTRING, type);
        }
    }

    private void raiseIssue(AstNode astNode, String message, DeclarationType type) {
        String finalMessage = String.format(message, type.value);
        if (type != DeclarationType.MODULE) {
            this.addIssue(MissingDocstringCheck.getNameNode(astNode), finalMessage);
        } else {
            this.getContext().createFileViolation((CodeCheck)this, finalMessage, new Object[0]);
        }
    }

    private static AstNode getNameNode(AstNode astNode) {
        return astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME, PythonGrammar.CLASSNAME});
    }

    private void visitFirstStatement(AstNode astNode, AstNode firstSimpleStmt, DeclarationType type) {
        Token token = firstSimpleStmt.getToken();
        if (token.getType().equals(PythonTokenType.STRING)) {
            if (EMPTY_STRING_REGEXP.matcher(token.getValue()).matches()) {
                this.raiseIssue(astNode, MESSAGE_EMPTY_DOCSTRING, type);
            }
        } else {
            this.raiseIssueNoDocstring(astNode, type);
        }
    }

    private static AstNode firstSimpleStmt(AstNode statement) {
        AstNode stmtList = statement.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
        if (stmtList != null) {
            return stmtList.getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT});
        }
        return null;
    }

    private static enum DeclarationType {
        MODULE("module"),
        CLASS("class"),
        METHOD("method"),
        FUNCTION("function");

        private final String value;

        private DeclarationType(String value) {
            this.value = value;
        }
    }
}

