/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S107", priority=Priority.MAJOR, name="Functions, methods and lambdas should not have too many parameters", tags={"brain-overload"})
@SqaleConstantRemediation(value="20min")
@ActivatedByDefault
public class TooManyParametersCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S107";
    private static final String MESSAGE = "%s has %s parameters, which is greater than the %s authorized.";
    private static final int DEFAULT_MAX = 7;
    @RuleProperty(key="max", defaultValue="7")
    public int max = 7;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.LAMBDEF});
    }

    public void visitNode(AstNode node) {
        int nbParameters = node.select().children(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST, PythonGrammar.VARARGSLIST}).children(new AstNodeType[]{PythonGrammar.TFPDEF, PythonGrammar.FPDEF}).size();
        if (nbParameters > this.max) {
            String name = "Lambda";
            if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
                String typeName = CheckUtils.isMethodDefinition(node) ? "Method" : "Function";
                name = node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getTokenOriginalValue();
                name = String.format("%s \"%s\"", typeName, name);
            }
            String message = String.format(MESSAGE, name, nbParameters, this.max);
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST, PythonGrammar.VARARGSLIST}), message);
        }
    }
}

