/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1110", priority=Priority.MAJOR, name="Useless parentheses around expressions should be removed to prevent any misunderstanding", tags={"confusing"})
@SqaleConstantRemediation(value="1min")
@ActivatedByDefault
public class UselessParenthesisCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1110";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.EXPR, PythonGrammar.NOT_TEST});
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{PythonGrammar.NOT_TEST})) {
            this.visitNotTest(node);
        } else if (node.getNumberOfChildren() == 1 && node.getFirstChild().is(new AstNodeType[]{PythonGrammar.ATOM})) {
            AstNode parent;
            AstNode atom = node.getFirstChild();
            AstSelect selectedParent = atom.select().parent().parent().parent();
            if (selectedParent.size() == 1 && UselessParenthesisCheck.isKeywordException(parent = selectedParent.get(0))) {
                this.checkAtom(atom, true);
                return;
            }
            this.checkAtom(atom, false);
        }
    }

    private static boolean isKeywordException(AstNode parent) {
        if ((parent.is(new AstNodeType[]{PythonGrammar.RETURN_STMT}) || parent.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR})) && parent.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}).getNumberOfChildren() == 1) {
            return true;
        }
        return parent.is(new AstNodeType[]{PythonGrammar.FOR_STMT}) && parent.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}).getChildren(new AstNodeType[]{PythonGrammar.EXPR}).size() == 1;
    }

    private void checkAtom(AstNode atom, boolean ignoreTestNumber) {
        if (UselessParenthesisCheck.violationCondition(atom, ignoreTestNumber)) {
            this.addIssue(atom, "Remove those useless parentheses");
        }
    }

    private static boolean violationCondition(AstNode atom, boolean ignoreTestNumber) {
        boolean result;
        List children = atom.getChildren();
        boolean bl = result = children.size() == 3 && ((AstNode)children.get(0)).is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}) && ((AstNode)children.get(2)).is(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}) && UselessParenthesisCheck.isOnASingleLine(atom);
        if (result && !ignoreTestNumber) {
            result = ((AstNode)children.get(1)).getChildren(new AstNodeType[]{PythonGrammar.TEST}).size() == 1 && ((AstNode)children.get(1)).getFirstChild(new AstNodeType[]{PythonPunctuator.COMMA}) == null;
        }
        return result;
    }

    private void visitNotTest(AstNode node) {
        boolean hasUselessParenthesis = node.select().children((AstNodeType)PythonGrammar.ATOM).children((AstNodeType)PythonGrammar.TESTLIST_COMP).children((AstNodeType)PythonGrammar.TEST).children(new AstNodeType[]{PythonGrammar.ATOM, PythonGrammar.COMPARISON}).isNotEmpty();
        if (hasUselessParenthesis) {
            this.checkAtom(node.getFirstChild().getNextSibling(), false);
        }
    }

    private static boolean isOnASingleLine(AstNode node) {
        return node.getTokenLine() == node.getLastToken().getLine();
    }
}

