/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S101", priority=Priority.MINOR, name="Class names should comply with a naming convention", tags={"convention"})
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class ClassNameCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S101";
    private static final String DEFAULT = "^[A-Z_][a-zA-Z0-9]+$";
    private static final String MESSAGE = "Rename class \"%s\" to match the regular expression %s.";
    @RuleProperty(key="format", defaultValue="^[A-Z_][a-zA-Z0-9]+$")
    public String format = "^[A-Z_][a-zA-Z0-9]+$";
    private Pattern pattern = null;

    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode astNode) {
        AstNode classNameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME});
        String className = classNameNode.getTokenValue();
        if (!this.pattern.matcher(className).matches()) {
            String message = String.format(MESSAGE, className, this.format);
            this.addIssue(classNameNode, message);
        }
    }
}

