/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;

@Rule(key="S3776", name="Cognitive Complexity of functions should not be too high", priority=Priority.CRITICAL, tags={"brain-overload"})
@ActivatedByDefault
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="5min", effortToFixDescription="per complexity point above the threshold")
public class CognitiveComplexityFunctionCheck
extends PythonCheck {
    private static final String MESSAGE = "Refactor this method to reduce its Cognitive Complexity from %s to the %s allowed.";
    public static final String CHECK_KEY = "S3776";
    private static final int DEFAULT_THRESHOLD = 15;
    private AstNode currentFunction = null;
    private int complexity;
    private int nestingLevel;
    private Set<PythonCheck.IssueLocation> secondaryLocations = new HashSet<PythonCheck.IssueLocation>();
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.IF_STMT, PythonKeyword.ELIF, PythonKeyword.ELSE, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.EXCEPT_CLAUSE, PythonGrammar.AND_TEST, PythonGrammar.OR_TEST, PythonGrammar.TEST, PythonGrammar.FUNCDEF, PythonGrammar.SUITE});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.FUNCDEF}) && this.currentFunction == null) {
            this.currentFunction = astNode;
            this.complexity = 0;
            this.nestingLevel = 0;
            this.secondaryLocations.clear();
        }
        if (this.currentFunction != null) {
            if (astNode.is(new AstNodeType[]{PythonGrammar.SUITE}) && this.incrementsNestingLevel(astNode)) {
                ++this.nestingLevel;
            }
            this.checkComplexity(astNode);
        }
    }

    private void checkComplexity(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.IF_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.EXCEPT_CLAUSE})) {
            this.incrementWithNesting(astNode.getFirstChild());
        }
        if (astNode.is(new AstNodeType[]{PythonKeyword.ELIF}) || astNode.is(new AstNodeType[]{PythonKeyword.ELSE}) && astNode.getNextSibling().is(new AstNodeType[]{PythonPunctuator.COLON})) {
            this.incrementWithoutNesting(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.AND_TEST, PythonGrammar.OR_TEST})) {
            this.incrementWithoutNesting(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.AND, PythonKeyword.OR}));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TEST}) && astNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.IF})) {
            this.incrementWithNesting(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IF}));
        }
    }

    public void leaveNode(AstNode astNode) {
        if (this.currentFunction == null) {
            return;
        }
        if (this.currentFunction.equals(astNode)) {
            if (this.complexity > this.threshold) {
                this.raiseIssue();
            }
            this.currentFunction = null;
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.SUITE}) && this.incrementsNestingLevel(astNode)) {
            --this.nestingLevel;
        }
    }

    private void raiseIssue() {
        String message = String.format(MESSAGE, this.complexity, this.threshold);
        PythonCheck.PreciseIssue issue = this.addIssue(this.currentFunction.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), message).withCost(this.complexity - this.threshold);
        this.secondaryLocations.forEach(arg_0 -> ((PythonCheck.PreciseIssue)issue).secondary(arg_0));
    }

    private boolean incrementsNestingLevel(AstNode astNode) {
        AstNode previousSibling = astNode.getPreviousSibling().getPreviousSibling();
        if (previousSibling.is(new AstNodeType[]{PythonKeyword.TRY, PythonKeyword.FINALLY})) {
            return false;
        }
        AstNode parent = astNode.getParent();
        return !parent.is(new AstNodeType[]{PythonGrammar.WITH_STMT, PythonGrammar.CLASSDEF}) && (!parent.is(new AstNodeType[]{PythonGrammar.FUNCDEF}) || !parent.equals(this.currentFunction));
    }

    private void incrementWithNesting(AstNode secondaryLocationNode) {
        int currentNodeComplexity = this.nestingLevel + 1;
        this.incrementComplexity(secondaryLocationNode, currentNodeComplexity);
    }

    private void incrementWithoutNesting(AstNode secondaryLocationNode) {
        this.incrementComplexity(secondaryLocationNode, 1);
    }

    private void incrementComplexity(AstNode secondaryLocationNode, int currentNodeComplexity) {
        this.secondaryLocations.add(new PythonCheck.IssueLocation(secondaryLocationNode, CognitiveComplexityFunctionCheck.secondaryMessage(currentNodeComplexity)));
        this.complexity += currentNodeComplexity;
    }

    private static String secondaryMessage(int complexity) {
        if (complexity == 1) {
            return "+1";
        }
        return String.format("+%s (incl %s for nesting)", complexity, complexity - 1);
    }
}

