/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2733", priority=Priority.CRITICAL, name="\"__exit__\" should accept type, value, and traceback arguments", tags={"bug"})
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class ExitHasBadArgumentsCheck
extends PythonCheck {
    public static final String MESSAGE_ADD = "Add the missing argument.";
    public static final String MESSAGE_REMOVE = "Remove the unnecessary argument.";
    private static final int EXIT_ARGUMENTS_NUMBER = 4;
    public static final String CHECK_KEY = "S2733";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode node) {
        if (!"__exit__".equals(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getToken().getValue())) {
            return;
        }
        AstNode varArgList = node.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (varArgList != null) {
            List arguments = varArgList.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF});
            for (AstNode argument : arguments) {
                if (argument.getPreviousSibling() == null || !argument.getPreviousSibling().is(new AstNodeType[]{PythonPunctuator.MUL_MUL, PythonPunctuator.MUL})) continue;
                return;
            }
            this.raiseIssue(node, arguments.size());
        } else {
            this.raiseIssue(node, 0);
        }
    }

    private void raiseIssue(AstNode node, int argumentsNumber) {
        if (argumentsNumber != 4) {
            String message = MESSAGE_ADD;
            if (argumentsNumber > 4) {
                message = MESSAGE_REMOVE;
            }
            AstNode funcName = node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME});
            AstNode rightParenthesis = node.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS});
            this.addIssue(new PythonCheck.IssueLocation(funcName, rightParenthesis, message));
        }
    }
}

