/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import java.text.MessageFormat;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonMetric;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="FileComplexity", name="Files should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="30min", effortToFixDescription="per complexity point above the threshold")
public class FileComplexityCheck
extends PythonCheck {
    private static final int DEFAULT_MAXIMUM_FILE_COMPLEXITY_THRESHOLD = 200;
    @RuleProperty(key="maximumFileComplexityThreshold", defaultValue="200")
    int maximumFileComplexityThreshold = 200;

    public void leaveFile(AstNode astNode) {
        SourceFile sourceFile = (SourceFile)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceFile, (MetricDef)PythonMetric.COMPLEXITY);
        if (complexity > this.maximumFileComplexityThreshold) {
            String message = MessageFormat.format("File has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", complexity, this.maximumFileComplexityThreshold);
            this.addFileIssue(message).withCost(complexity - this.maximumFileComplexityThreshold);
        }
    }
}

