/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="FunctionComplexity", name="Functions should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point above the threshold")
public class FunctionComplexityCheck
extends PythonCheck {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 15;
    private static final String MESSAGE = "Function has a complexity of %s which is greater than %s authorized.";
    @RuleProperty(key="maximumFunctionComplexityThreshold", defaultValue="15")
    int maximumFunctionComplexityThreshold = 15;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void leaveNode(AstNode node) {
        SourceFunction function = (SourceFunction)this.getContext().peekSourceCode();
        int complexity = function.getInt((MetricDef)PythonMetric.COMPLEXITY);
        if (complexity > this.maximumFunctionComplexityThreshold) {
            String message = String.format(MESSAGE, complexity, this.maximumFunctionComplexityThreshold);
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), message).withCost(complexity - this.maximumFunctionComplexityThreshold);
        }
    }
}

