/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1313", priority=Priority.MAJOR, name="IP addresses should not be hardcoded", tags={"cert", "security"})
@SqaleConstantRemediation(value="30min")
@ActivatedByDefault
public class HardcodedIPCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1313";
    private static final String IP_ADDRESS_V4_REGEX = "((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))";
    private static final String IP_ADDRESS_V6_REGEX = "((::)?([\\da-fA-F]{1,4}::?){2,7})([\\da-fA-F]{1,4})?";
    private static final Pattern patternV4 = Pattern.compile("((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))");
    private static final Pattern patternV6 = Pattern.compile("((::)?([\\da-fA-F]{1,4}::?){2,7})([\\da-fA-F]{1,4})?");
    String message = "Make this IP \"%s\" address configurable.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.STRING});
    }

    public void visitNode(AstNode node) {
        String string = node.getTokenOriginalValue();
        if (HardcodedIPCheck.isMultilineString(string)) {
            return;
        }
        Matcher matcher = patternV4.matcher(string);
        if (matcher.find()) {
            String ipAddress = matcher.group();
            this.addIssue(node, String.format(this.message, ipAddress));
        } else {
            String ipAddress;
            matcher = patternV6.matcher(string);
            if (matcher.find() && (ipAddress = matcher.group()).length() > 8) {
                this.addIssue(node, String.format(this.message, ipAddress));
            }
        }
    }

    private static boolean isMultilineString(String string) {
        return string.endsWith("'''") || string.endsWith("\"\"\"");
    }
}

