/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1764", name="Identical expressions should not be used on both sides of a binary operator", priority=Priority.MAJOR, tags={"bug", "cert"})
@SqaleConstantRemediation(value="2min")
@ActivatedByDefault
public class IdenticalExpressionOnBinaryOperatorCheck
extends PythonCheck {
    private static final List<String> EXCLUDED_OPERATOR_TYPES = ImmutableList.of((Object)"*", (Object)"+");

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.M_EXPR, PythonGrammar.A_EXPR, PythonGrammar.SHIFT_EXPR, PythonGrammar.AND_EXPR, PythonGrammar.XOR_EXPR, PythonGrammar.OR_EXPR, PythonGrammar.COMPARISON, PythonGrammar.OR_TEST, PythonGrammar.AND_TEST});
    }

    public void visitNode(AstNode expression) {
        List children = expression.getChildren();
        AstNode leftOperand = (AstNode)children.get(0);
        String operator = ((AstNode)children.get(1)).getTokenValue();
        AstNode rightOperand = (AstNode)children.get(2);
        if (!EXCLUDED_OPERATOR_TYPES.contains(operator) && CheckUtils.equalNodes(leftOperand, rightOperand) && !IdenticalExpressionOnBinaryOperatorCheck.isLeftShiftBy1(leftOperand, operator)) {
            this.addIssue(rightOperand, "Correct one of the identical sub-expressions on both sides of operator \"" + operator + "\".").secondary(leftOperand, "");
        }
    }

    private static boolean isLeftShiftBy1(AstNode leftOperand, String operator) {
        return "<<".equals(operator) && "1".equals(leftOperand.getTokenValue());
    }
}

