/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="LongIntegerWithLowercaseSuffixUsage", priority=Priority.MINOR, name="Long suffix \"L\" should be upper case", tags={"convention"}, status="DEPRECATED")
@SqaleConstantRemediation(value="2min")
public class LongIntegerWithLowercaseSuffixUsageCheck
extends PythonCheck {
    public static final String CHECK_KEY = "LongIntegerWithLowercaseSuffixUsage";
    private static final String MESSAGE = "Replace suffix in long integers from lower case \"l\" to upper case \"L\".";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.NUMBER});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (value.charAt(value.length() - 1) == 'l') {
            this.addIssue(astNode, MESSAGE);
        }
    }
}

