/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2325", name="Methods that don't access instance data should be \"static\"", priority=Priority.MAJOR, tags={"performance"})
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class MethodShouldBeStaticCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S2325";
    private static final String MESSAGE = "Make this method static.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode node) {
        String self;
        if (MethodShouldBeStaticCheck.isMethodOfNonDerivedClass(node) && !MethodShouldBeStaticCheck.alreadyStaticMethod(node) && !MethodShouldBeStaticCheck.isBuiltInMethod(node) && MethodShouldBeStaticCheck.hasValuableCode(node) && (self = MethodShouldBeStaticCheck.getFirstArgument(node)) != null && !MethodShouldBeStaticCheck.isUsed(node, self) && !MethodShouldBeStaticCheck.onlyRaisesNotImplementedError(node)) {
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), MESSAGE);
        }
    }

    private static boolean isMethodOfNonDerivedClass(AstNode node) {
        return CheckUtils.isMethodDefinition(node) && !CheckUtils.classHasInheritance(node.getFirstAncestor((AstNodeType)PythonGrammar.CLASSDEF));
    }

    private static boolean onlyRaisesNotImplementedError(AstNode funcDef) {
        AstNode suite = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.isEmpty()) {
            AstNode statementList = suite.getFirstChild();
            if (MethodShouldBeStaticCheck.raisesNotImplementedError(statementList)) {
                return true;
            }
        } else if (statements.size() <= 2) {
            if (statements.size() == 2 && !MethodShouldBeStaticCheck.isDocstring((AstNode)statements.get(0))) {
                return false;
            }
            AstNode statementList = ((AstNode)statements.get(statements.size() - 1)).getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
            if (statementList != null && MethodShouldBeStaticCheck.raisesNotImplementedError(statementList)) {
                return true;
            }
        }
        return false;
    }

    private static boolean raisesNotImplementedError(AstNode statementList) {
        AstNode testStatement;
        return MethodShouldBeStaticCheck.isRaise(statementList) && (testStatement = statementList.getFirstDescendant(new AstNodeType[]{PythonGrammar.TEST})) != null && "NotImplementedError".equals(testStatement.getToken().getValue());
    }

    private static boolean hasValuableCode(AstNode funcDef) {
        AstNode statementList = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
        if (statementList != null && statementList.getChildren(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).size() == 1) {
            return !statementList.getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).getFirstChild().is(new AstNodeType[]{PythonGrammar.PASS_STMT});
        }
        List statements = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1) {
            return !MethodShouldBeStaticCheck.isDocstringOrPass((AstNode)statements.get(0));
        }
        return statements.size() != 2 || !MethodShouldBeStaticCheck.isDocstringAndPass((AstNode)statements.get(0), (AstNode)statements.get(1));
    }

    private static boolean isDocstring(AstNode statement) {
        return statement.getToken().getType().equals(PythonTokenType.STRING);
    }

    private static boolean isDocstringOrPass(AstNode statement) {
        return statement.getFirstDescendant(new AstNodeType[]{PythonGrammar.PASS_STMT}) != null || statement.getToken().getType().equals(PythonTokenType.STRING);
    }

    private static boolean isDocstringAndPass(AstNode statement1, AstNode statement2) {
        return statement1.getToken().getType().equals(PythonTokenType.STRING) && statement2.getFirstDescendant(new AstNodeType[]{PythonGrammar.PASS_STMT}) != null;
    }

    private static boolean isRaise(AstNode statementList) {
        return statementList.getFirstChild().hasDescendant(new AstNodeType[]{PythonGrammar.RAISE_STMT});
    }

    private static boolean isUsed(AstNode funcDef, String self) {
        List names = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}).getDescendants(new AstNodeType[]{PythonGrammar.NAME});
        for (AstNode name : names) {
            if (!name.getTokenValue().equals(self)) continue;
            return true;
        }
        return false;
    }

    private static String getFirstArgument(AstNode funcDef) {
        AstNode argList = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (argList != null) {
            return argList.getFirstDescendant(new AstNodeType[]{PythonGrammar.NAME}).getTokenValue();
        }
        return null;
    }

    private static boolean alreadyStaticMethod(AstNode funcDef) {
        AstNode decorators = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        if (decorators != null) {
            List decoratorList = decorators.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR});
            for (AstNode decorator : decoratorList) {
                AstNode name = decorator.getFirstDescendant(new AstNodeType[]{PythonGrammar.NAME});
                if (name == null || !"staticmethod".equals(name.getTokenValue()) && !"classmethod".equals(name.getTokenValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isBuiltInMethod(AstNode funcDef) {
        String doubleUnderscore;
        String name = funcDef.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getToken().getValue();
        return name.startsWith(doubleUnderscore = "__") && name.endsWith(doubleUnderscore);
    }
}

