/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;

@Rule(key="S1720", priority=Priority.MAJOR, name="Docstrings should be defined")
@SqaleConstantRemediation(value="5min")
public class MissingDocstringCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1720";
    private static final Pattern EMPTY_STRING_REGEXP = Pattern.compile("([bruBRU]+)?('\\s*')|(\"\\s*\")|('''\\s*''')|(\"\"\"\\s*\"\"\")");
    private static final String MESSAGE_NO_DOCSTRING = "Add a docstring to this %s.";
    private static final String MESSAGE_EMPTY_DOCSTRING = "The docstring for this %s should not be empty.";

    public void init() {
        DocstringExtractor.DOCUMENTABLE_NODE_TYPES.stream().forEach(xva$0 -> this.subscribeTo(new AstNodeType[]{xva$0}));
    }

    public void visitNode(AstNode astNode) {
        DeclarationType type = MissingDocstringCheck.getType(astNode);
        Token docstring = DocstringExtractor.extractDocstring((AstNode)astNode);
        if (docstring == null) {
            this.raiseIssueNoDocstring(astNode, type);
        } else if (EMPTY_STRING_REGEXP.matcher(docstring.getValue()).matches()) {
            this.raiseIssue(astNode, MESSAGE_EMPTY_DOCSTRING, type);
        }
    }

    private static DeclarationType getType(AstNode node) {
        if (node.is(new AstNodeType[]{PythonGrammar.FILE_INPUT})) {
            return DeclarationType.MODULE;
        }
        if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            if (CheckUtils.isMethodDefinition(node)) {
                return DeclarationType.METHOD;
            }
            return DeclarationType.FUNCTION;
        }
        if (node.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
            return DeclarationType.CLASS;
        }
        return null;
    }

    private void raiseIssueNoDocstring(AstNode astNode, DeclarationType type) {
        if (type != DeclarationType.METHOD) {
            this.raiseIssue(astNode, MESSAGE_NO_DOCSTRING, type);
        }
    }

    private void raiseIssue(AstNode astNode, String message, DeclarationType type) {
        String finalMessage = String.format(message, type.value);
        if (type != DeclarationType.MODULE) {
            this.addIssue(MissingDocstringCheck.getNameNode(astNode), finalMessage);
        } else {
            this.getContext().createFileViolation((CodeCheck)this, finalMessage, new Object[0]);
        }
    }

    private static AstNode getNameNode(AstNode astNode) {
        return astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME, PythonGrammar.CLASSNAME});
    }

    private static enum DeclarationType {
        MODULE("module"),
        CLASS("class"),
        METHOD("method"),
        FUNCTION("function");

        private final String value;

        private DeclarationType(String value) {
            this.value = value;
        }
    }
}

