/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1722", priority=Priority.MAJOR, name="New-style classes should be used")
@SqaleConstantRemediation(value="2min")
public class NewStyleClassCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1722";
    private static final String MESSAGE = "Add inheritance from \"object\" or some other new-style class.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode node) {
        AstNode argListNode = node.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        if (argListNode == null || !argListNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.ARGUMENT})) {
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}), MESSAGE);
        }
    }
}

