/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.CharsetAwareVisitor;
import org.sonar.squidbridge.SquidAstVisitorContext;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1131", name="Lines should not end with trailing whitespaces", priority=Priority.MINOR, tags={"convention"})
@SqaleConstantRemediation(value="1min")
public class TrailingWhitespaceCheck
extends SquidCheck<Grammar>
implements CharsetAwareVisitor {
    public static final String CHECK_KEY = "S1131";
    public static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private static final Pattern TRAILING_WS = Pattern.compile("\\s$");
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitFile(@Nullable AstNode astNode) {
        SquidAstVisitorContext context = this.getContext();
        File file = context.getFile();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), this.charset);){
            String line;
            int lineNr = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNr;
                if (!TRAILING_WS.matcher(line).find()) continue;
                context.createLineViolation((CodeCheck)this, MESSAGE, lineNr, new Object[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read " + file, e);
        }
    }
}

