/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum PythonBuiltinFunctions {
    INSTANCE;

    private static final Set<String> BUILTINS;

    public static boolean contains(String name) {
        return BUILTINS.contains(name);
    }

    @VisibleForTesting
    static Set<String> loadBuiltinNames(URL resourceUrl) {
        try {
            List lines = Resources.readLines((URL)resourceUrl, (Charset)StandardCharsets.UTF_8);
            return lines.stream().map(String::trim).filter(s -> !s.startsWith("#")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load " + resourceUrl, e);
        }
    }

    static {
        BUILTINS = PythonBuiltinFunctions.loadBuiltinNames(PythonBuiltinFunctions.class.getResource("builtins.txt"));
    }
}

