/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.AbstractNameCheck;

public abstract class AbstractFunctionNameCheck
extends AbstractNameCheck {
    private static final String DEFAULT = "^[a-z_][a-z0-9_]{2,}$";
    private static final String MESSAGE = "Rename %s \"%s\" to match the regular expression %s.";
    @RuleProperty(key="format", defaultValue="^[a-z_][a-z0-9_]{2,}$")
    public String format = "^[a-z_][a-z0-9_]{2,}$";

    @Override
    protected String format() {
        return this.format;
    }

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.FUNCDEF);
    }

    public void visitNode(AstNode astNode) {
        if (!this.shouldCheckFunctionDeclaration(astNode)) {
            return;
        }
        AstNode nameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME});
        String name = nameNode.getTokenValue();
        if (!this.pattern().matcher(name).matches()) {
            String message = String.format(MESSAGE, this.typeName(), name, this.format);
            this.addIssue(nameNode, message);
        }
    }

    public abstract String typeName();

    public abstract boolean shouldCheckFunctionDeclaration(AstNode var1);
}

