/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonTokenType;

@Rule(key="S1717")
public class BackslashInStringCheck
extends PythonCheck {
    private static final String MESSAGE = "Remove this \"\\\", add another \"\\\" to escape it, or make this a raw string.";
    private static final String VALID_ESCAPED_CHARACTERS = "abfnrtvxnNrtuU\\'\"0123456789\n\r";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonTokenType.STRING);
    }

    public void visitNode(AstNode node) {
        String string = node.getTokenOriginalValue();
        int length = string.length();
        boolean isEscaped = false;
        boolean inPrefix = true;
        boolean isThreeQuotes = length > 5 && "\"\"".equals(string.substring(1, 3));
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (inPrefix = BackslashInStringCheck.isInPrefix(inPrefix, c)) {
                if (c != 'r' && c != 'R') continue;
                return;
            }
            if (isEscaped && VALID_ESCAPED_CHARACTERS.indexOf(c) == -1 && !BackslashInStringCheck.isBackslashedSpaceAfterInlineMarkup(isThreeQuotes, string, i, c)) {
                this.addIssue(node, MESSAGE);
            }
            isEscaped = c == '\\' && !isEscaped;
        }
    }

    private static boolean isBackslashedSpaceAfterInlineMarkup(boolean isThreeQuotes, String string, int position, char current) {
        if (isThreeQuotes && current == ' ' && position > 6) {
            char twoCharactersBefore = string.charAt(position - 2);
            switch (twoCharactersBefore) {
                case '*': 
                case '_': 
                case '`': 
                case '|': {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isInPrefix(boolean wasInPrefix, char currentChar) {
        return wasInPrefix && currentChar != '\"' && currentChar != '\'';
    }
}

