/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;

@Rule(key="S1716")
public class BreakContinueOutsideLoopCheck
extends PythonCheck {
    private static final String MESSAGE = "Remove this \"%s\" statement";
    public static final String CHECK_KEY = "S1716";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.BREAK_STMT, (Object)PythonGrammar.CONTINUE_STMT);
    }

    public void visitNode(AstNode node) {
        for (AstNode currentParent = node.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (currentParent.is(new AstNodeType[]{PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT})) {
                return;
            }
            if (!currentParent.is(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF})) continue;
            this.raiseIssue(node);
            return;
        }
        this.raiseIssue(node);
    }

    private void raiseIssue(AstNode node) {
        this.addIssue(node, String.format(MESSAGE, node.getToken().getValue()));
    }
}

