/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.checks.NewSymbolsAnalyzer;

@Rule(key="S1700")
public class FieldDuplicatesClassNameCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1700";
    private static final String MESSAGE = "Rename field \"%s\"";

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.CLASSDEF);
    }

    public void visitNode(AstNode astNode) {
        if (!CheckUtils.classHasInheritance(astNode)) {
            List<Token> allFields = new NewSymbolsAnalyzer().getClassFields(astNode);
            String className = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}).getTokenValue();
            for (Token name : allFields) {
                if (!className.equalsIgnoreCase(name.getValue())) continue;
                this.addIssue(name, String.format(MESSAGE, name.getValue())).secondary(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}), "Class declaration");
            }
        }
    }
}

