/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.checks.NewSymbolsAnalyzer;

@Rule(key="S116")
public class FieldNameCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S116";
    private static final String MESSAGE = "Rename this field \"%s\" to match the regular expression %s.";
    private static final String CONSTANT_PATTERN = "^[_A-Z][A-Z0-9_]*$";
    private static final String DEFAULT = "^[_a-z][_a-z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[_a-z][_a-z0-9]*$")
    public String format = "^[_a-z][_a-z0-9]*$";
    private Pattern pattern = null;
    private Pattern constantPattern = null;

    public Set<AstNodeType> subscribedKinds() {
        return ImmutableSet.of((Object)PythonGrammar.CLASSDEF);
    }

    public void visitNode(AstNode astNode) {
        if (!CheckUtils.classHasInheritance(astNode)) {
            List<Token> allFields = new NewSymbolsAnalyzer().getClassFields(astNode);
            this.checkNames(allFields);
        }
    }

    private void checkNames(List<Token> varNames) {
        if (this.constantPattern == null) {
            this.constantPattern = Pattern.compile(CONSTANT_PATTERN);
        }
        for (Token name : varNames) {
            if (this.constantPattern.matcher(name.getValue()).matches()) continue;
            this.checkName(name);
        }
    }

    private void checkName(Token token) {
        String name = token.getValue();
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
        if (!this.pattern.matcher(name).matches()) {
            this.addIssue(token, String.format(MESSAGE, name, this.format));
        }
    }
}

