/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;

@Rule(key="S1134")
public class FixmeCommentCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1134";
    private static final String FIXME_COMMENT_PATTERN = "^#[ ]*fixme.*";
    private static final String MESSAGE = "Take the required action to fix the issue indicated by this \"FIXME\" comment.";
    private Pattern pattern;

    public void visitFile(AstNode astNode) {
        this.pattern = Pattern.compile(FIXME_COMMENT_PATTERN, 2);
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment = trivia.getToken().getValue();
            if (!this.pattern.matcher(comment).matches()) continue;
            this.addIssue(trivia.getToken(), MESSAGE);
        }
    }
}

